#include <bits/stdc++.h>
using namespace std;

struct Mast {
    long long x, h;
    int idx;
};
bool cmp(const Mast& A, const Mast& B){
    return A.x < B.x;
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if (!(cin >> n)) return 0;
    vector<long long> xs(n), hs(n);
    for (int i=0;i<n;++i) cin >> xs[i];
    for (int i=0;i<n;++i) cin >> hs[i];

    vector<Mast> a(n);
    for (int i = 0; i < n; ++i) a[i] = {xs[i], hs[i], i};
    sort(a.begin(), a.end(), cmp);

    vector<long long> x(n), h(n);
    vector<int> orig(n);
    for (int i = 0; i < n; ++i) {
        x[i] = a[i].x;
        h[i] = a[i].h;
        orig[i] = a[i].idx;
    }

    const long long INF = (1LL<<60);

    vector<int> L(n, -1), R(n, -1);
    {
        vector<int> st;
        for (int i = 0; i < n; ++i) {
            while (!st.empty() && h[st.back()] < h[i]) st.pop_back();
            if (!st.empty()) L[i] = st.back();
            st.push_back(i);
        }
    }
    {
        vector<int> st;
        for (int i = n-1; i >= 0; --i) {
            while (!st.empty() && h[st.back()] < h[i]) st.pop_back();
            if (!st.empty()) R[i] = st.back();
            st.push_back(i);
        }
    }

    vector<long long> twoM(n-1);
    for (int i = 0; i+1 < n; ++i) {
        long long dx = x[i+1] - x[i];
        twoM[i] = h[i] + h[i+1] - dx; 
    }

    vector<long long> ans(n, INF);

    for (int i = 0; i < n; ++i) {
        if (L[i] != -1) ans[i] = min(ans[i], x[i] - x[L[i]]);
        if (R[i] != -1) ans[i] = min(ans[i], x[R[i]] - x[i]);

        if (i > 0 && h[i-1] >= h[i]) {
            long long hi = h[i];
            long long cond = twoM[i-1]; 
            if (cond >= 2*hi) {
                ans[i] = min(ans[i], 0LL);
            } else {
                long long d = (x[i] - x[i-1]) - (h[i-1] - hi);
                ans[i] = min(ans[i], d);
            }
        }
        if (i+1 < n && h[i+1] >= h[i]) {
            long long hi = h[i];
            long long cond = twoM[i];
            if (cond >= 2*hi) {
                ans[i] = min(ans[i], 0LL);
            } else {
                long long d = (x[i+1] - x[i]) - (h[i+1] - hi);
                ans[i] = min(ans[i], d);
            }
        }
    }

    vector<long long> out(n);
    for (int i = 0; i < n; ++i) {
        if (ans[i] == INF) out[orig[i]] = -1;
        else out[orig[i]] = ans[i];
    }

    for (int i = 0; i < n; ++i) cout << out[i] << "\n";
    return 0;
}